declare module 'interfaces/networks' {
  export interface NetworkIdsResult {
    virtualCatalogue: {
      networkIds: string[];
    };
  }
}

declare module 'interfaces/locations' {
  import { Connection } from 'mystique/types/common';

  export interface Location {
    ref: string;
    name: string;
    postcode: string;
  }

  export interface LocationsForNetwork {
    networks: Connection<LocationsForNetworkNode>;
  }

  interface LocationsForNetworkNode {
    locations: Connection<LocationsForNetworkNodeLocation>;
  }

  interface LocationsForNetworkNodeLocation {
    ref: string;
    name: string;
    primaryAddress: {
      postcode: string;
    };
  }
}

declare module 'interfaces/address' {
  import {Connection} from 'mystique/types/common';

  export interface DefaultAddress {
    customerAddresses: Connection<CustomerAddress>;
  }

  export interface CustomerAddress {
    street: string;
    postcode: number;
    country: string;
    city: string;
    companyName?: string;
    name?: string;
    state?: string;
  }

  export interface MultiCustomerAddress extends CustomerAddress {
    ref: string;
  }
}

declare module 'interfaces/fulfilmentPlans' {
  import {Connection} from 'mystique/types/common';

  export interface Attribute {
    name: string;
    value: any;
    type: string;
  }

  interface AttributeArray extends Array<Attribute> {
    byName?: Record<string, any>;
  }

  interface FulfilmentPlanInterface {
    deliveryType: string;
    fulfilmentOptionId?: string;
  }

  export interface FulfilmentHDPlanInterface extends FulfilmentPlanInterface {
    eta: string;
    ref: string;
    pickUpLocation: string;
    carrier?: string;
  }

  export interface FulfilmentCCPlanInterface extends FulfilmentPlanInterface {
    locations?: string[];
  }

  export interface FulfilmentOptionResult {
    createFulfilmentOption: FulfilmentOption;
  }

  interface FulfilmentOption {
    id: string
    plans: Connection<FulfilmentPlan>
    attributes: AttributeArray
    products: FulfilmentOptionProduct[]
  }

  interface FulfilmentOptionProduct {
    productRef: string
    catalogueRef: string
    requestedQuantity: number
  }

  interface FulfilmentPlan {
    ref: string;
    status: string;
    eta: string;
    type: string;
    attributes: any;
    fulfilments: FulfilmentPlanFulfilment[];
  }

  interface FulfilmentPlanFulfilment {
    fulfilmentType: string;
    locationRef: string;
    items: FulfilmentPlanFulfilmentItem[];
  }

  interface FulfilmentPlanFulfilmentItem {
    productRef: string;
    catalogueRef: string;
    availableQuantity: number;
    requestedQuantity: number;
  }
}