# Additional custom components
Register new field component\
`createOrderWizard`

Register new templates\
`currency`\
`currencySymbol`

[Registration Example](src/index.tsx)

# Manifest example
Action with new component can be added as `createComment` mutation user action with overridden 'text' field  \
[Example of action usage (lines 75-98)](manifests/fc.mystique.manifest.oms.fragment.ordermanagement.ts)

## Hack and limitations
Mystique mutation action doesn't allow to group few input fields and use one component for them. So hack was used here. 
Mutation `createComment` was used instead of `createOrder` mutation to create custom action and group all input fields to one custom component.
At the end of the creation process `createOrderWizard` component will replace `createComment` mutation to `createOrder`.
As result, only new order will be created and user will be navigated to new order details page.

'Create Order' action definition (typescript):
```typescript
{
  type: 'mutation',
    label: 'i18n:fc.se.field.create.order.user.action.label',
    name: 'createComment',
    filter: {
    type: 'include',
      names: ['text'],
  },
  args: {
    entityId: '-1',
      entityType:
    'i18n:fc.om.orders.index.userAction.entityType.order',
  },
  overrides: {
    text: {
      component: 'createOrderWizard',
    },
  },
}
```

# Additional notes
After order creation, user will be navigated to details page of new order
(by default: `#/orders/{orderId}/{activeRetailerId}/{orderRef}`)

This behaviour can be changed in file `CreateOrder.tsx`:
[CreateOrder.tsx:446-448](src/forms/fields/order/СreateOrder/CreateOrder.tsx)

```typescript
window.location.hash = TemplateRegistry.render(
  `#/orders/${resp.data.createOrder.id}/${activeRetailer}/${resp.data.createOrder.ref}`,
);
```

# Translation example
[Translation](i18n/locales/en/translation.json)

# Dependencies changes
Add new dependencies\
"@types/uuid": "^8.3.4"\
"react-uuid": "^2.0.0"\
"uuid": "^9.0.0"\
"@material-ui/icons": "^4.11.3"\
"react-icons": "^4.3.1"\
"@material-ui/lab": "^4.0.0-alpha.61"\
"@date-io/moment": "1.3.13"\
"moment": "^2.29.3"

Add new devDependencies\
"@types/uuid": "^8.3.4"\
"@types/react-icons": "^3.0.0"

# webpack.config.ts changes
replace\
const isMaterialUIComponent = /^@material-ui\/core\/.+$/;\
with\
const isMaterialUIComponent = /^@material-ui\/core\/(?!utils$).+$/;

# Related settings
`AGGREGATE_CATALOGUE_FOR_ADD_PRODUCT_ITEMS` - name of catalogue to provide product availability information for 'Add Item' modal

| Property    | Value                                         |
|-------------|-----------------------------------------------|
| Name        | AGGREGATE_CATALOGUE_FOR_ADD_PRODUCT_ITEMS     |
| Context     | ACCOUNT                                       |
| Context Id  | 0                                             |
| Value Type  | STRING                                        |
| Value       | Name of catalogue (for example: VC:AGGREGATE) |

`ORDER_TYPES` - list of Order Types with localisation labels to be used on Create Order Wizard

| Property   | Value                                         |
|------------|-----------------------------------------------|
| Name       | ORDER_TYPES                                   |
| Context    | ACCOUNT                                       |
| Context Id | 0                                             |
| Value Type | JSON                                          |
| Value      | List of Order Types with labels (see example) |

ORDER_TYPES value example:
```json
[
    {
        "label": "{{i18n 'fc.se.field.create.order.click.and.collect'}}",
        "value": "CC"
    },
    {
        "label": "{{i18n 'fc.se.field.create.order.home.delivery'}}",
        "value": "HD"
    }
]
```

`PAYMENT.CARDTYPE` - list of Card Types which are available to select for Financial Transactions

| Property   | Value                            |
|------------|----------------------------------|
| Name       | PAYMENT.CARDTYPE                 |
| Context    | RETAILER                         |
| Context Id | <retailer_id>                    |
| Value Type | JSON                             |
| Value      | List of Card Types (see example) |

PAYMENT.CARDTYPE value example:
```json
[
    {
        "name": "MASTERCARD"
    },
    {
        "name": "VISA"
    },
    {
        "name": "GIFTCARD"
    },
    {
        "name": "AMEX"
    },
    {
        "name": "DISCOVER"
    },
    {
        "name": "UNIONPAY"
    },
    {
        "name": "JCB"
    },
    {
        "name": "MAESTRO"
    },
    {
        "name": "INTERAC"
    }
]
```

`DEFAULT_TAX_TYPE` - tax information to be used by default (see [useDefaultTariffValue.tsx](src/hooks/useDefaultTariffValue.tsx))

| Property   | Value                   |
|------------|-------------------------|
| Name       | DEFAULT_TAX_TYPE        |
| Context    | RETAILER                |
| Context Id | <retailer_id>           |
| Value Type | JSON                    |
| Value      | Default tax tariff name |

DEFAULT_TAX_TYPE value example: 
```json
{
  "country": "GB",
  "group": "STANDARD",
  "tariff": "VAT"
}
```
Additionally, setting named as tariff name have to exist. This setting shows amount of tax.  

| Property   | Value                          |
|------------|--------------------------------|
| Name       | tariff name (for example: VAT) |
| Context    | RETAILER                       |
| Context Id | <retailer_id>                  |
| Value Type | STRING                         |
| Value      | Tax amount (for example, 0.2)  |

`PAYMENT.CURRENCY` - list of currencies which are available to select for Financial Transactions.

| Property   | Value                        |
|------------|------------------------------|
| Name       | PAYMENT.CURRENCY             |
| Context    | RETAILER                     |
| Context Id | <retailer_id>                |
| Value Type | JSON                         |
| Value      | List of available currencies |

PAYMENT.CURRENCY value example:
```json
[
  {
    "name": "AUD"
  },
  {
    "name": "NZD"
  },
  {
    "name": "USD"
  },
  {
    "name": "GBP"
  },
  {
    "name": "EUR"
  },
  {
    "name": "SGD"
  },
  {
    "name": "INR"
  },
  {
    "name": "MXN"
  }
]
```

`PAYMENT.METHOD` - list of payment methods which are available to select for Financial Transactions.

| Property   | Value                             |
|------------|-----------------------------------|
| Name       | PAYMENT.METHOD                    |
| Context    | RETAILER                          |
| Context Id | <retailer_id>                     |
| Value Type | JSON                              |
| Value      | List of available payment methods |

PAYMENT.METHOD value example:
```json
[
  {
    "name": "CREDITCARD"
  },
  {
    "name": "PAYPAL"
  },
  {
    "name": "GIFTCARD"
  },
  {
    "name": "EFT"
  },
  {
    "name": "CASH"
  },
  {
    "name": "AFTERPAY"
  }
]
```

`PAYMENT.PROVIDER` - list of payment providers which are available to select for Financial Transactions.

| Property   | Value                               |
|------------|-------------------------------------|
| Name       | PAYMENT.PROVIDER                    |
| Context    | RETAILER                            |
| Context Id | <retailer_id>                       |
| Value Type | JSON                                |
| Value      | List of available payment providers |

PAYMENT.PROVIDER value example:
```json
[
  {
    "name": "BRAINTREE"
  },
  {
    "name": "CYBERSOURCE"
  },
  {
    "name": "PAYPAL"
  },
  {
    "name": "GIVEX"
  },
  {
    "name": "AFTERPAY"
  },
  {
    "name": "FAT_ZEBRA"
  },
  {
    "name": "BASIC_CREDIT"
  }
]
```

[List of constants for related settings](src/constants/SettingNames.ts)


# Issues
Different naming of Base Virtual Catalogue (BASE and VC:BASE) [getBaseLocations.tsx:43](src/queries/getBaseLocations.tsx)

Different naming of Product Catalogue (MASTER and DEFAULT)
- [AddProductItemsModal.tsx:208](src/components/AddProductItems/AddProductItemsModal.tsx)
- [CreateOrder.tsx:353](src/forms/fields/order/СreateOrder/CreateOrder.tsx)
- [CreateOrder.tsx:417](src/forms/fields/order/СreateOrder/CreateOrder.tsx)

Difference with Fulfilment Option workflows \
SE Environment - FULFILMENT_OPTIONS::DEFAULT workflow\
Clear Environment - FULFILMENT_OPTIONS::CC and FULFILMENT_OPTIONS::HD workflows\
[createFulfilmentPlans.tsx:88](src/queries/createFulfilmentPlans.tsx)

TODO - need to check structural difference of FULFILMENT_OPTIONS workflows

> Possible solution: replace hardcoded references to passing via component properties or setting.
> But for Fulfilment Option workflow selection more complex solutions have to be designed because selecting of
> FO workflow can depend on new order configuration (for example, select FULFILMENT_OPTION::HD workflow for HD order or
> select FULFILMENT_OPTION::CC workflow for CC Order).

# Documentation
<https://fluentpne.atlassian.net/wiki/spaces/SE/pages/5528092916/Create+Order>\
