import React, { createContext } from 'react';
import { CreateOrderInterface } from './CreateOrder';
import { Location } from 'interfaces/locations';
import { CustomerAddress } from 'interfaces/address';
import { CustomerInterface } from './content/CustomerAndOrderType';

interface CreateOrderContextInterface {
  createOrderInf?: CreateOrderInterface;
  availableLocations?: Location[];
  customerAddresses?: {
    customerName?: CustomerInterface;
    defaultAddress?: CustomerAddress;
  };
  setCreateOrderInf?: React.Dispatch<
    React.SetStateAction<CreateOrderInterface | undefined>
  >;
}

export const CreateOrderContext = createContext<CreateOrderContextInterface>(
  {},
);