import {FC, useContext, useEffect, useState} from 'react';
import { Grid, Switch, Typography } from '@material-ui/core';
import { useI18n } from 'mystique/hooks/useI18n';
import FulfilmentPlans from './FulfilmentPlans';
import MultiBasketCollection from './MultiBasketCollection';
import {
  FulfilmentCCPlanInterface,
  FulfilmentHDPlanInterface,
} from 'interfaces/fulfilmentPlans';
import { CreateOrderContext } from '../CreateOrderContext';
import { CreateOrderInterface } from '../CreateOrder';

interface DeliveryTypesProps {
  onChange: (value: unknown, property: string) => void;
  fulfilmentPlans: FulfilmentHDPlanInterface[] | FulfilmentCCPlanInterface[];
  fulfilmentPlanRef?: string;
}

const DeliveryTypes: FC<DeliveryTypesProps> = ({
  onChange,
  fulfilmentPlans = [],
  fulfilmentPlanRef,
}) => {
  const [useMultiBasket, setUseMultiBasket] = useState(false);
  const { translate } = useI18n();
  const { availableLocations: locations, createOrderInf } = useContext(
    CreateOrderContext,
  );
  const {
    type: orderType,
    products,
    multiOrder,
    pickupLocationRef,
    deliveryType,
  } = createOrderInf as CreateOrderInterface;

  useEffect(() => {
    onChange(useMultiBasket, 'useMultiOrder');
  }, [useMultiBasket]);

  return (
    <>
      <Typography component="div">
        <Grid component="label" container alignItems="center" spacing={1}>
          <Grid item>
            {translate('fc.se.field.create.order.third.step.basket')}
          </Grid>
          <Grid item>
            <Switch
              checked={useMultiBasket}
              onChange={(_event, checked) => {
                setUseMultiBasket(checked);
              }}
            />
          </Grid>
          <Grid item>
            {translate('fc.se.field.create.order.third.step.item.collection')}
          </Grid>
        </Grid>
      </Typography>
      {!useMultiBasket ? (
        <>
          <FulfilmentPlans
            onChange={onChange}
            locations={locations}
            fulfilmentPlans={fulfilmentPlans}
            orderType={orderType}
            deliveryType={deliveryType}
            fulfilmentPlanRef={fulfilmentPlanRef}
            locationRef={pickupLocationRef}
          />
        </>
      ) : (
        <MultiBasketCollection
          onChange={onChange}
          products={multiOrder || products}
          multiOrder={multiOrder}
        />
      )}
    </>
  );
};

export default DeliveryTypes;