import { getQuery } from 'mystique/hooks/getQuery';
import { CustomerAddress, DefaultAddress } from 'interfaces/address';

const defaultAddressQuery = `
query($name: [String]!) {
    customerAddresses(name: $name, first: 1) {
      edges {
        node {
          companyName
          state
          street
          postcode
          country
          city
        }
      }
    }
}`;

interface GetDefaultCustomerAddressProps {
  customerName: string;
}

export const getDefaultCustomerAddress = ({
  customerName,
}: GetDefaultCustomerAddressProps): Promise<CustomerAddress | undefined> => {
  return getQuery<DefaultAddress>(defaultAddressQuery, {
    name: customerName,
  }).then((resp) => {
    return resp.data?.customerAddresses.edges[0]?.node;
  });
};