export const getLocaleDateString = (currentLanguage: string): string => {
  const formats: Record<string, string> = {
    'en-AU': 'dd/MM/yyyy',
    'en-US': 'MM/dd/yyyy',
    en: 'MM/dd/yyyy',
    ru: 'dd.MM.yyyy',
  };

  return formats[currentLanguage] || 'dd/MM/yyyy';
};