export const concat = (arr: string[], sep: string) => arr.join(sep);

export const humanifyV2 = (str: string) => {
  const formattedStr = str.replace(/:/g, ' ').replace(/_/g, ' ');
  const words = formattedStr.split(' ');
  const transformedWords = words.map((word) => {
    if (isUpperCase(word)) {
      const lowercaseWord = word.toLowerCase();
      return lowercaseWord.charAt(0).toUpperCase() + lowercaseWord.slice(1);
    } else {
      return word;
    }
  });
  return transformedWords.join(' ');
};

function isUpperCase(str: string) {
  return str === str.toUpperCase();
}
