import { TemplateRegistry } from 'mystique/registry/TemplateRegistry';

export const currency = (...args: any[]) => {
  const hash = args.pop().hash;
  const value = args[0] || 0;
  const currency = args[1];
  const locale = hash._locale;
  const decimalPlaces = hash._decimalPlaces ?? 2;
  let formattedValue = value;
  if (currency) {
    try {
      formattedValue = new Intl.NumberFormat(locale, {
        style: 'currency',
        currency: currency,
        minimumFractionDigits: decimalPlaces,
        maximumFractionDigits: decimalPlaces,
      }).format(value);
    } catch (e) {
      console.error(e);
    }
  }
  return TemplateRegistry.noEscape(`${formattedValue}`);
};

export const currencySymbol = (currency: string) => {
  return TemplateRegistry.render(`{{currency 0 '${currency}' _decimalPlaces=0}}`).replace(/\d/g, '');
};