package com.fluentcommerce.connect.custom;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fluentcommerce.connect.core.configuration.data.AccountReference;
import com.fluentcommerce.connect.core.listener.data.ConnectSDKMessage;
import com.fluentcommerce.connect.core.listener.publisher.ListenerPublisherService;
import com.fluentcommerce.connect.custom.data.WeatherData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

@RestController
@RequestMapping("/api/v1/fluent-connect/weather")
public class WeatherUpdateController {


    private final ListenerPublisherService publishService;

    @Value("${account}")
    private String account;
    @Value("${retailer}")
    private String retailer;

    @Autowired
    public WeatherUpdateController(final ListenerPublisherService publishService) {
        this.publishService = publishService;
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST, consumes = "application/json", produces = "application/json")
    public ResponseEntity<?> updateWeather(@RequestBody WeatherData weatherData) {
        final var accountReference = AccountReference.of(account, retailer);

        try {
            publishService.publishMessage(ConnectSDKMessage.builder()
                    .id(UUID.randomUUID().toString())
                    .name("fc.connect.sample-weather-update")
                    .accountId(accountReference.accountId())
                    .retailerId(accountReference.retailerId())
                    .payload(ConnectSDKMessage.toJson(weatherData))
                    .build());
        } catch (final JsonProcessingException e) {
            return ResponseEntity.internalServerError().build();
        }
        return ResponseEntity.ok().build();
    }
}
