package com.fluentcommerce.connect.custom.job;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fluentcommerce.connect.core.exception.JobExecutionException;
import com.fluentcommerce.connect.core.handler.HandlerInfo;
import com.fluentcommerce.connect.core.handler.context.JobHandlerContext;
import com.fluentcommerce.connect.core.job.extend.JobHandler;
import com.fluentcommerce.connect.core.listener.data.ConnectSDKMessage;
import com.fluentcommerce.connect.custom.data.LocationWeatherData;
import com.fluentcommerce.connect.custom.utils.WeatherService;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;

@Slf4j
@Component
@HandlerInfo(name = "location-weather-update-job", route = "location-weather-update-job")
public class LocationWeatherUpdateJobHandler implements JobHandler {
    final Set<String> locations = Set.of("LOC_SYD", "LOC_MELB");

    @Override
    public void run(@NotNull final JobHandlerContext context) throws JobExecutionException {
        locations.forEach(location -> sendMessage(context, new LocationWeatherData(location, WeatherService.getWeatherReport())));
    }

    private void sendMessage(@NotNull final JobHandlerContext context, final LocationWeatherData weatherData) {
        try {
            context.getPublishService().publishMessage(ConnectSDKMessage.builder()
                    .id(UUID.randomUUID().toString())
                    .correlationId(Collections.singleton(context.getJobExecutionRequest().getExecutionId().toString()))
                    .name("fc.connect.sample-weather-update-location")
                    .accountId(context.getAccountReference().accountId())
                    .retailerId(context.getAccountReference().retailerId())
                    .payload(ConnectSDKMessage.toJson(weatherData))
                    .build());
        } catch (final JsonProcessingException e) {
            log.error("Unable to send message", e);
        }
    }
}
