package com.fluentcommerce.connect.custom.job;

import com.fluentcommerce.connect.core.exception.JobExecutionException;
import com.fluentcommerce.connect.core.handler.HandlerInfo;
import com.fluentcommerce.connect.core.handler.context.JobHandlerContext;
import com.fluentcommerce.connect.core.job.extend.JobHandler;
import com.fluentcommerce.connect.custom.utils.UpsertSettingUtils;
import com.fluentcommerce.connect.custom.utils.WeatherService;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@HandlerInfo(name = "weather-update-job", route = "weather-update-job")
public class WeatherUpdateJobHandler implements JobHandler {
    @Override
    public void run(@NotNull final JobHandlerContext context) throws JobExecutionException {
        UpsertSettingUtils.upsertSetting(WeatherService.getWeatherReport(), context, UpsertSettingUtils.FLUENT_SETTING_KEY);
    }
}
