package com.fluentcommerce.connect.custom.message;

import com.fluentcommerce.connect.core.exception.HandlerRetryException;
import com.fluentcommerce.connect.core.exception.UnprocessableMessageException;
import com.fluentcommerce.connect.core.handler.HandlerInfo;
import com.fluentcommerce.connect.core.handler.context.MessageHandlerContext;
import com.fluentcommerce.connect.core.listener.router.MessageHandler;
import com.fluentcommerce.connect.custom.utils.UpsertSettingUtils;
import com.fluentcommerce.connect.custom.data.LocationWeatherData;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

import java.util.Optional;

@Slf4j
@Component
@HandlerInfo(name = "location-weather-update", route = "fc.connect.sample-weather-update-location")
public class LocationWeatherDataMessageHandler implements MessageHandler {
    @Override
    public void processMessage(@NotNull final MessageHandlerContext context) throws UnprocessableMessageException, HandlerRetryException {
        final var weatherUpdate = getPayload(context);
        UpsertSettingUtils.upsertSetting(weatherUpdate.weatherData(), context, UpsertSettingUtils.FLUENT_SETTING_KEY + "." + weatherUpdate.location());
    }

    protected LocationWeatherData getPayload(final MessageHandlerContext context) {
        final Optional<LocationWeatherData> payload = context.getMessagePayload(LocationWeatherData.class);
        if (payload.isPresent()) {
            return payload.get();
        }
        throw new UnprocessableMessageException("Unable to get message payload");
    }
}
