package com.fluentcommerce.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import lombok.Builder;
import lombok.Value;
import org.apache.commons.lang3.StringUtils;

@Value
@Builder(builderClassName = "Builder",
    toBuilder = true)
@JsonDeserialize(builder = SettingListEntity.Builder.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SettingListEntity {

    String label;
    String value;

    @JsonPOJOBuilder(withPrefix = "")
    public static final class Builder {

    }

}
