package com.fluentcommerce.model.attribute;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fluentretail.api.model.location.Address;
import java.util.Map;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(builderClassName = "Builder",
    toBuilder = true)
@JsonDeserialize(builder = Attribute.Builder.class)
public class Attribute {

    String name;
    String type;
    Object value;

    public static Attribute from(Map<String, Object> attribute) {
        Builder builder = Attribute.builder()
            .name((String) attribute.get("name"));
        Object value = attribute.get("value");

        String type = "OBJECT";
        if (value instanceof String) {
            if (((String) value).length() > com.fluentretail.api.model.attribute.Attribute.MAX_STRING_LENGTH) {
                type = "TEXT";
            } else {
                type = "STRING";
            }
        } else if (value instanceof Integer) {
            type = "INTEGER";
        } else if (value instanceof Boolean) {
            type = "BOOLEAN";
        } else if (value instanceof Address) {
            type = "ADDRESS";
        }
        builder.value(value);
        builder.type(type);
        return builder.build();
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static final class Builder {

    }
}

