package com.fluentretail.se.gi.model.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(builderClassName = "Builder",
    toBuilder = true)
@JsonDeserialize(builder = Items.Builder.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@AllArgsConstructor
public class Items {

    String skuRef;
    String locationRef;
    String fulfilmentId;
    int quantity;
    int reserveQty;
    int correctionQty;
    int saleQty;
    int cancelQty;

    @JsonPOJOBuilder(withPrefix = "")
    public static final class Builder {

    }
}
