package com.fluentretail.se.helper.oms;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;

import com.fluentcommerce.se.common.graphql.queries.order.GetOrderByIdBaseQuery;
import com.fluentcommerce.se.common.graphql.queries.setting.GetSettingsByNameQuery;
import com.fluentretail.rubix.v2.context.Context;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;

/**
 * @author Alex L.
 */
@Slf4j
public class GqlQueryHelper {

    private final Context context;


    public GqlQueryHelper(Context context) {
        this.context = context;
    }


    public GetOrderByIdBaseQuery.Data getOrderById(String id, String orderItemCursor) {
        GetOrderByIdBaseQuery getOrderById = GetOrderByIdBaseQuery.builder()
            .id(id)
            .includeOrderItems(true)
            .orderItemCount(100)
            .orderItemCursor(orderItemCursor)
            .build();
        return (GetOrderByIdBaseQuery.Data) context.api().query(getOrderById);
    }

    public GetOrderByIdBaseQuery.Data getOrderById(String id, String orderItemCursor, boolean includeCustomer,
        boolean includeAttributes,
        boolean includefulfilmentChoice, boolean includefulfilments, boolean includeOrderItems,
        boolean includeOrderItemProduct) {
        GetOrderByIdBaseQuery getOrderById = GetOrderByIdBaseQuery.builder()
            .id(id)
            .orderItemCursor(orderItemCursor)
            .includeCustomer(includeCustomer)
            .includeAttributes(includeAttributes)
            .includefulfilmentChoice(includefulfilmentChoice)
            .includefulfilments(includefulfilments)
            .includeOrderItems(includeOrderItems)
            .includeOrderItemProduct(includeOrderItemProduct)
            .orderItemCount(100)
            .fulfilmentCount(100)
            .build();
        return (GetOrderByIdBaseQuery.Data) context.api().query(getOrderById);
    }

    public Set<GetOrderByIdBaseQuery.Node> getAllOrderItems(GetOrderByIdBaseQuery.Data getOrderData) {
        Set<GetOrderByIdBaseQuery.Node> result = new HashSet<>();
        if (getOrderData.orderById() == null || getOrderData.orderById().items() == null
            || isEmpty(getOrderData.orderById().items().edges())) {
            return result;
        }
        getOrderData.orderById().items().edges().stream().map(GetOrderByIdBaseQuery.Edge::node).forEach(result::add);
        return populateNextPage(getOrderData, result);
    }


    public Map<String, GetOrderByIdBaseQuery.Node> getAllOrderItemsByOrderItemRef(
        GetOrderByIdBaseQuery.Data getOrderData) {
        return getAllOrderItems(getOrderData).stream()
            .collect(Collectors.toMap(GetOrderByIdBaseQuery.Node::ref, Function.identity()));
    }

    private Set<GetOrderByIdBaseQuery.Node> populateNextPage(GetOrderByIdBaseQuery.Data getOrderData,
        Set<GetOrderByIdBaseQuery.Node> result) {
        String orderItemsCursor;
        while (getOrderData.orderById().items().pageInfo().hasNextPage()) {
            List<GetOrderByIdBaseQuery.Edge> orderItemsList = getOrderData.orderById().items().edges();
            int index = orderItemsList.size() - 1;
            orderItemsCursor = orderItemsList.get(index).cursor();
            getOrderData = getOrderById(getOrderData.orderById().id(), orderItemsCursor);
            getOrderData.orderById().items().edges().stream().map(GetOrderByIdBaseQuery.Edge::node)
                .forEach(result::add);
        }
        return result;
    }

    public GetSettingsByNameQuery buildSettingsByNameQuery(List<String> settingNames, List<String> settingContext,
        List<Integer> contextId, String afterCursor) {
        return GetSettingsByNameQuery.builder()
            .name(settingNames)
            .context(settingContext)
            .contextId(contextId)
            .after(afterCursor)
            .build();
    }

    public GetSettingsByNameQuery.Data runSettingsByNameQuery(GetSettingsByNameQuery query) {
        return (GetSettingsByNameQuery.Data) context.api().query(query);
    }

    public Set<GetSettingsByNameQuery.Node> getAllSettingsByNameQuery(GetSettingsByNameQuery.Variables variables,
        GetSettingsByNameQuery.Data data) {
        Set<GetSettingsByNameQuery.Node> result = new HashSet<>();

        if (data == null || data.settings() == null || isEmpty(data.settings().edges())) {
            return result;
        }

        data.settings().edges().stream().map(GetSettingsByNameQuery.Edge::node).forEach(result::add);
        return populateSettingsNextPage(variables, data, result);
    }

    private Set<GetSettingsByNameQuery.Node> populateSettingsNextPage(GetSettingsByNameQuery.Variables variables,
        GetSettingsByNameQuery.Data data,
        Set<GetSettingsByNameQuery.Node> result) {
        String settingsCursor;
        while (data.settings().pageInfo() != null && data.settings().pageInfo().hasNextPage()) {
            List<GetSettingsByNameQuery.Edge> edgesList = data.settings().edges();
            int index = edgesList.size() - 1;
            settingsCursor = edgesList.get(index).cursor();

            GetSettingsByNameQuery nextQuery =
                buildSettingsByNameQuery(variables.name(), variables.context(), variables.contextId(), settingsCursor);
            data = runSettingsByNameQuery(nextQuery);
            data.settings().edges().stream().map(GetSettingsByNameQuery.Edge::node).forEach(result::add);
        }
        return result;
    }
}
