package com.fluentretail.se.model.oms;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Value;

@Value
@AllArgsConstructor
@lombok.Builder(builderClassName = "Builder",
    toBuilder = true)
@JsonDeserialize(builder = EntityReference.Builder.class)
@EqualsAndHashCode
public class EntityReference {

    String type;
    String subType;
    String ref;
    String id;

    @JsonPOJOBuilder(withPrefix = "")
    public static class Builder {

    }
}
