package com.fluentretail.se.plugins.util;

@SuppressWarnings("unused")
public class Constants {

    public static final Integer DEFAULT_PAGE_SIZE = 100;
    public static final String DEFAULT = "DEFAULT";
    public static final String ITEMS = "items";

    public static final String PROP_STATUS = "status";
    public static final String PROP_EVENT_NAME = "eventName";
    public static final String PROP_DELAY = "delay";
    public static final String PROP_ATTRIBUTE_NAME = "attributeName";
    public static final String PROP_ATTRIBUTE_VALUE = "attributeValue";
    public static final String PROP_SETTING = "setting";
    public static final String PROP_INVENTORY_CATALOGUE_REF = "inventoryCatalogueRef";

    public static final String SUBSTITUTION_PRICE = "price";
    public static final String SUBSTITUTION_TAX_PRICE = "taxPrice";
    public static final String SUBSTITUTION_TOTAL_PRICE = "totalPrice";
    public static final String SUBSTITUTION_TOTAL_TAX_PRICE = "totalTaxPrice";
    public static final String ATTR_SUBSTITUTION_QUANTITY = "substituteQuantity";
    public static final String ATTR_SUBSTITUTION_PRICE = "substitutePrice";

    public static final String FULFILMENT_PRICE_ATTRIBUTE = "FULFILMENT_PRICE";
    public static final String FULFILMENT_TAX_PRICE_ATTRIBUTE = "FULFILMENT_TAX_PRICE";

    public static final String DEFAULT_TAX_TYPE = "DEFAULT_TAX_TYPE";
    public static final String DEFAULT_RETURN_DESTINATION_LOCATION = "DEFAULT_RETURN_DESTINATION_LOCATION";

    // Credit Memo
    public static final String CREDIT_MEMO_ITEM = "CREDIT_MEMO_ITEM";
    public static final String PROP_CREDIT_MEMO_TYPE = "creditMemoType";
    public static final String PROP_CREDIT_MEMO_ITEM_TYPE = "creditMemoItemType";
    public static final String EVENT_ATTR_ENTITY_REFERENCE = "entityReference";
    public static final String EVENT_ATTR_CREDIT_REASON_CODE = "creditReasonCode";

    // Invoices
    public static final String INVOICE = "INVOICE";
    public static final String INVOICE_ITEM_TYPE = "INVOICE_ITEM";
    public static final String INVOICE_TYPE_RETURN = "RETURN";

    public static class ReturnOrder {

        public static final String PROP_CONFIRM_RETURN_ORDER_EVENT_NAME = "confirmReturnOrder";
        public static final String PROP_REJECT_RETURN_ORDER_EVENT_NAME = "rejectReturnOrder";
        public static final String PROP_VALID_RETURN_CONDITION_LIST = "returnConditions";
        public static final String PROP_VALID_RETURN_FULFILMENT_STATUS_LIST = "fulfilmentStatuses";
        public static final String PROP_EXCHANGE_ORDER_EXISTED = "exchangeOrderExisted";

        // Product (Variant and Standard) & Order Item
        public static final String ATTR_RETURN_TYPE = "RETURN_TYPE";
        public static final String ATTR_RETURN_PERIOD = "RETURN_PERIOD";
        public static final String ATTR_RETURNABLE_QTY = "returnableQty";
        public static final String ATTR_RETURN_DATE_LIMIT = "RETURN_DATE_LIMIT";

        // Order
        public static final String ATTR_COMPLETE_DATE = "COMPLETE_DATE";
        public static final String ATTR_RETURN_ORDER_REF = "RETURN_ORDER_REF";
        public static final String ATTR_EXCHANGE_ORDER_REF = "EXCHANGE_ORDER_REF";

        // Return Order
        public static final String ATTR_RETURN_REJECTION_REASONS = "RETURN_REJECTION_REASONS";
        public static final String REJECTION_ITEM = "orderItem";
        public static final String REJECTION_PRODUCT = "product";
        public static final String REJECTION_REASON = "reason";
        public static final Integer DEFAULT_RMA_EXPIRATION_PERIOD_DAYS = 7;
        public static final String RMA_EXPIRY_ON_DAYS_CONFIG = "RMA_EXPIRY_ON_DAYS";
        public static final String ATTR_REMAIN_REFUND_AMOUNT = "REMAIN_REFUND_AMOUNT";
        public static final String PROP_ORIGINAL_REFUND_AMOUNT = "originalAmount";
        public static final String PROP_BALANCE_REFUND_AMOUNT = "balanceAmount";

        public static class ReturnType {

            public static final String NONE = "NONE";
            public static final String DEFAULT = "DEFAULT";
            public static final String RMA = "RMA";
        }

        public static class RejectionReason {

            public static final String NOT_RETURNABLE = "NOT_RETURNABLE";
            public static final String RETURN_EXPIRED = "RETURN_EXPIRED";
            public static final String WRONG_QUANTITY = "WRONG_QUANTITY";
        }
    }

    public enum BooleanOptions {
        TRUE,
        FALSE
    }

    public interface EntityType {

        String INVENTORY_CATALOGUE = "INVENTORY_CATALOGUE";

        String ORDER = "ORDER";
        String FULFILMENT = "FULFILMENT";
        String ARTICLE = "ARTICLE";
        String CONSIGNMENT = "CONSIGNMENT";

        String LOCATION = "LOCATION";
        String WAVE = "WAVE";

        String FULFILMENT_PLAN = "FULFILMENT_PLAN";
        String FULFILMENT_OPTIONS = "FULFILMENT_OPTIONS";

        String RETURN_ORDER = "RETURN_ORDER";
        String RETURN_FULFILMENT = "RETURN_FULFILMENT";

        String CREDIT_MEMO = "CREDIT_MEMO";
        String BILLING_ACCOUNT = "BILLING_ACCOUNT";
    }

    public interface EventField {

        String EVENT_FIELD_NEW_REVISED_ORDER_LINK = "NewRevisedOrderLink";
        String EVENT_FIELD_NEW_REVISED_ORDER_ID = "NewRevisedOrderId";
    }

    public static class ErrorCodes {

        public static final int ERROR_CODE_400 = 400;
    }

    public static class Attributes {

        public static class Types {

            public static final String STRING = "STRING";
            public static final String DATE = "DATE";
            public static final String JSON = "JSON";
            public static final String INTEGER = "INTEGER";
        }
    }

    public static class Settings {

        public static class Context {

            public static final String RETAILER = "RETAILER";
            public static final String ACCOUNT = "ACCOUNT";
            public static final String GLOBAL = "GLOBAL";
        }
    }
}