package com.fluentretail.se.plugins.util;

import com.fluentretail.rubix.event.Event;
import com.fluentretail.rubix.exceptions.PropertyNotFoundException;
import com.fluentretail.rubix.v2.context.Context;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

@Slf4j
public class RuleUtils {

    private static final String EXCEPTION_MISSING_ENTITY_REF = "Entity reference missing";
    private static final String EXCEPTION_MISSING_ROOT_ENTITY_REF = "Root Entity reference missing";

    public static String buildLogPrefix(String className, final Event event) {
        final String entityId = event.getEntityId();
        final String entityRef = event.getEntityRef();
        final String entityType = event.getEntityType();
        final String accountId = event.getAccountId();
        return "[" + accountId + "][SE-FEATURE][" + className + "][" + entityType + " Id=" + entityId + ", Ref="
            + entityRef + "]";
    }

    public static boolean validateRulePropsIsNotEmpty(Context context, String... ruleProps) {
        if (ruleProps != null) {
            for (String ruleProp : ruleProps) {
                if (null == context.getProp(ruleProp) || context.getProp(ruleProp).isEmpty()) {
                    throw new PropertyNotFoundException(400, ruleProp);
                }
            }
        }
        return true;
    }

    public static boolean isNotNull(Object... objects) {
        if (null != objects) {
            for (final Object object : objects) {
                if (null == object) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static void validateContextRefRootRef(Context context) {

        // validate on the rule props configuration
        if (StringUtils.isEmpty(context.getEntity().getRef())) {
            throw new IllegalArgumentException(EXCEPTION_MISSING_ENTITY_REF);
        }

        if (StringUtils.isEmpty(context.getEvent().getRootEntityRef())) {
            throw new IllegalArgumentException(EXCEPTION_MISSING_ROOT_ENTITY_REF);
        }
    }
}
