package com.fluentretail.se.plugins.util;

import static com.fluentretail.se.plugins.util.Constants.Settings.Context.ACCOUNT;
import static com.fluentretail.se.plugins.util.Constants.Settings.Context.GLOBAL;
import static com.fluentretail.se.plugins.util.Constants.Settings.Context.RETAILER;
import static java.lang.Integer.valueOf;
import static org.apache.commons.lang3.StringUtils.isBlank;

import com.fluentcommerce.se.common.graphql.queries.setting.GetSettingsQuery;
import com.fluentretail.rubix.v2.context.Context;
import com.google.common.collect.ImmutableList;
import java.util.List;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SettingUtils {

    public static String getSettingValue(Context context, String settingName, String defaultValue) {
        if (isBlank(settingName)) {
            log.info("Setting name is empty, using default value {}", defaultValue);
            return defaultValue;
        }
        try {
            GetSettingsQuery.Edge settingEdge = getSetting(context, settingName);
            if (settingEdge != null) {
                return settingEdge.node().value();
            }
        } catch (Exception e) {
            log.error("Exception occured while executing " + SettingUtils.class.getSimpleName(), e);
        }
        return defaultValue;
    }

    public static Integer getSettingValue(Context context, String settingName, Integer defaultValue) {
        if (isBlank(settingName)) {
            log.info("Setting name is empty, using default value {}", defaultValue);
            return defaultValue;
        }
        try {
            GetSettingsQuery.Edge settingEdge = getSetting(context, settingName);
            if (settingEdge != null) {
                return valueOf(settingEdge.node().value());
            }
        } catch (Exception e) {
            log.error("Exception occured while executing, use default value " + SettingUtils.class.getSimpleName(), e);
        }
        return defaultValue;
    }

    private static GetSettingsQuery.Edge getSetting(Context context, String settingName) {
        List<GetSettingsQuery.Edge> edges = getSettingData(context, RETAILER, context.getEvent().getRetailerId(),
            settingName).settings().edges();
        log.info("[SE-FEATURE]: {} RETAILER setting:{}", SettingUtils.class.getSimpleName(), edges);
        if (edges.size() == 0) {
            edges = getSettingData(context, ACCOUNT, "0", settingName).settings().edges();
            log.info("[SE-FEATURE]: {} ACCOUNT setting:{}", SettingUtils.class.getSimpleName(), edges);
            if (edges.size() == 0) {
                edges = getSettingData(context, GLOBAL, "0", settingName).settings().edges();
                log.info("[SE-FEATURE]: {} GLOBAL setting:{}", SettingUtils.class.getSimpleName(), edges);
            }
        }
        if (edges.stream().findFirst().isPresent()) {
            return edges.stream().findFirst().get();
        }

        return null;
    }

    static GetSettingsQuery.Data getSettingData(Context context, String settingContext, String contextId,
        String settingName) {
        GetSettingsQuery querySettings = GetSettingsQuery.builder().name(ImmutableList.of(settingName))
            .context(ImmutableList.of(settingContext))
            .contextId(ImmutableList.of(Integer.parseInt(contextId))).build();
        log.info("[SE-FEATURE]: {} - GrapQL Params - settingNameList: {}, contextList: {} contextIdList :{}",
            SettingUtils.class.getSimpleName(),
            settingName,
            settingContext,
            Long.parseLong(contextId));

        GetSettingsQuery.Data settingsData = (GetSettingsQuery.Data) context.api().query(querySettings);
        return settingsData;
    }
}
