package com.fluentretail.se.plugins.util.helpers;

import com.fluentcommerce.se.common.graphql.queries.setting.GetSettingsByNameQuery;
import com.fluentretail.rubix.v2.context.Context;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SettingHelpers {

    public static final String SETTING_CONTEXT_RETAILER = "RETAILER";
    public static final String SETTING_CONTEXT_ACCOUNT = "ACCOUNT";
    public static final String SETTING_CONTEXT_GLOBAL = "GLOBAL";

    public static GetSettingsByNameQuery.Data searchSettingInAllContext(Context context, String settingName) {
        GetSettingsByNameQuery.Data response =
            searchSettingByNameAndContext(context, settingName, SETTING_CONTEXT_RETAILER,
                Integer.parseInt(context.getEvent().getRetailerId()));

        if (!hasSettingResult(response)) {
            response = searchSettingByNameAndContext(context, settingName, SETTING_CONTEXT_ACCOUNT, 0);
        }

        if (!hasSettingResult(response)) {
            response = searchSettingByNameAndContext(context, settingName, SETTING_CONTEXT_GLOBAL, 0);
        }

        log.info("Searching for setting with name = '{}', result found = {}", settingName, response);
        return response;
    }

    public static GetSettingsByNameQuery.Data searchSettingByNameAndContext(Context context, String settingName,
        String settingContext, int settingContextId) {
        return (GetSettingsByNameQuery.Data) context.api().query(
            GetSettingsByNameQuery.builder()
                .name(ImmutableList.of(settingName))
                .context(ImmutableList.of(settingContext))
                .contextId(ImmutableList.of(settingContextId))
                .build()
        );
    }

    public static boolean hasSettingResult(GetSettingsByNameQuery.Data response) {
        return (response != null && response.settings() != null && response.settings().edges().size() != 0);
    }

    public static Map<String, Object> transformSettingResponseToMap(GetSettingsByNameQuery.Data response) {
        Map<String, Object> result = new HashMap<>();

        if (response == null || response.settings() == null || response.settings().edges().isEmpty()) {
            return result;
        }

        return response.settings().edges().stream().map(edge -> edge.node())
            .filter(node -> node != null && getNodeValue(node) != null)
            .collect(Collectors.toMap(k -> k.name(), v -> getNodeValue(v)));
    }

    public static Object getNodeValue(GetSettingsByNameQuery.Node node) {
        switch (node.valueType()) {
            case "LOB":
            case "JSON":
                return node.lobValue();
            default:
                return node.value();
        }
    }

    public static class PostcodeSetting {

        @Getter
        ArrayList<PostcodeEntity> postcodes;

        @Override
        public String toString() {
            return "PostcodeSetting{"
                + "postcodes=" + postcodes
                + '}';
        }
    }

    public static class PostcodeEntity {

        @Getter
        String postcode;

        @Getter
        String type;

        @Getter
        String category;

        @Override
        public String toString() {
            return "PostcodeEntity{"
                + "postcode='" + postcode + '\''
                + ", type='" + type + '\''
                + ", category='" + category + '\''
                + '}';
        }
    }
}
