package com.fluentretail.se.plugins.util.v2;

import static com.fluentretail.se.plugins.util.Constants.ReturnOrder.ATTR_RETURNABLE_QTY;

import com.fluentcommerce.se.common.graphql.queries.order.GetOrderByRefQuery;
import com.fluentretail.rubix.v2.context.Context;
import com.fluentretail.se.plugins.util.AttributeUtils;
import com.fluentretail.se.plugins.util.Constants;
import org.apache.commons.lang3.StringUtils;

public class OrderUtils {

    public static GetOrderByRefQuery.Data getOrderByRefQuery(Context context,
        String orderRef,
        boolean includeAttributes,
        boolean includeCustomer,
        boolean includeFulfilmentChoice,
        boolean includeFulfilments,
        boolean includeOrderItems,
        boolean includeArticles,
        boolean includeConsignmentArticles,
        boolean includeFinancialTransactions
    ) {
        GetOrderByRefQuery.Builder getOrderByRef = GetOrderByRefQuery.builder()
            .ref(orderRef)
            .includeAttributes(includeAttributes)
            .includeCustomer(includeCustomer)
            .includeFulfilmentChoice(includeFulfilmentChoice)
            .includeFulfilments(includeFulfilments)
            .includeOrderItems(includeOrderItems)
            .includeArticles(includeArticles)
            .includeConsignmentArticles(includeConsignmentArticles)
            .includeFinancialTransactions(includeFinancialTransactions)
            .articleCount(Constants.DEFAULT_PAGE_SIZE)
            .fulfilmentItemCount(Constants.DEFAULT_PAGE_SIZE)
            .fulfilmentCount(Constants.DEFAULT_PAGE_SIZE)
            .orderItemCount(Constants.DEFAULT_PAGE_SIZE)
            .financialTransactionsCount(Constants.DEFAULT_PAGE_SIZE)
            .consignmentArticlesCount(Constants.DEFAULT_PAGE_SIZE);

        return (GetOrderByRefQuery.Data) context.api().query(getOrderByRef.build());
    }

    public static boolean allItemsReturned(GetOrderByRefQuery.Order order) {
        // Check the returnableQty exists for each order item and has a value of zero
        return order.items().itemEdges().stream().allMatch(itemEdge -> {
            if (itemEdge.itemNode().attributes() != null) {
                String returnQtyAttribute =
                    AttributeUtils.getAttributeValue(ATTR_RETURNABLE_QTY, itemEdge.itemNode().attributes());
                if (StringUtils.isNotBlank(returnQtyAttribute)) {
                    if (returnQtyAttribute.equals("0")) {
                        return true;
                    }
                }
            }

            // Treat zero cost SKUs as not required to return
            return (itemEdge.itemNode().totalPrice() == null || itemEdge.itemNode().totalPrice() == 0) &&
                (itemEdge.itemNode().totalTaxPrice() == null || itemEdge.itemNode().totalTaxPrice() == 0);
        });
    }
}
