declare module 'mystique/utils' {

    /**
      * This functions recursively applies a decorator to an object. The decorator is a function which takes in the 
      * value and allows you to alter the value on the fly. 
      * 
      * @param target the target object to decorate
      * @param fieldType the decorator is only applied to values of this type
      * @param valueDecorator the decorator function
      **/
    export const recursiveValueDecorator: (
      target: any,
      fieldType: 'string' | 'object',
      /**
       * This is the value decorator function which is applied to all values in the target object.
       * @param value the value to decorate
       * @param tgt the original target object passed in to the recursive value decorator
       * @param key the key used to access this value 
       * @param path the path from the root of the target object to this value
       * @returns {any} a decorated value
       */
      valueDecorator: (value: any, tgt: any, key: string, path: string[]) => any
    ) => any;
  
  }