## Additional custom components
Register new field components\
`returnItemsExtended`\
`destinationLocation`\
`pickupLocation`\
`exchangeItems`\
`emptyField`

Register new components\
`fc.se.button.show.attributes`\
`fc.se.quantity.selector`\
`fc.se.remove.button`\
`fc.se.photo.capture`\
`fc.se.quantity.list`

[Registration Example](src/index.tsx)

## Translation example
[Translation](i18n/locales/en/translation.json)

## Dependencies changes
Add new dependencies\
"@material-ui/icons": "^4.11.3"\
"@material-ui/lab": "^4.0.0-alpha.61"\
"react-icons": "^4.3.1"\
"react-html5-camera-photo": "^1.5.10"\
"css-loader": "^6.7.1"\
"style-loader": "^3.3.1"

Add new devDependencies\
"@types/react-html5-camera-photo": "^1.5.1",

## webpack.config.ts changes
1. replace\
`const isMaterialUIComponent = /^@material-ui\/core\/.+$/;\`
with\
`const isMaterialUIComponent = /^@material-ui\/core\/(?!utils$).+$/;`

2. add additional loaders to config
```ts
  {
    test: /\.css$/i,
    use: ['style-loader', 'css-loader'],
  }
```

## Related settings
`AGGREGATE_CATALOGUE_FOR_ADD_PRODUCT_ITEMS` - name of catalogue to provide product availability information for 'Add Item' modal

| Property    | Value                                         |
|-------------|-----------------------------------------------|
| Name        | AGGREGATE_CATALOGUE_FOR_ADD_PRODUCT_ITEMS     |
| Context     | ACCOUNT                                       |
| Context Id  | 0                                             |
| Value Type  | STRING                                        |
| Value       | Name of catalogue (for example: VC:AGGREGATE) |


`DEFAULT_TAX_TYPE` - tax information to be used by default (see [useDefaultTariffValue.tsx](src/hooks/useDefaultTariffValue.tsx))

| Property   | Value                   |
|------------|-------------------------|
| Name       | DEFAULT_TAX_TYPE        |
| Context    | RETAILER                |
| Context Id | <retailer_id>           |
| Value Type | JSON                    |
| Value      | Default tax tariff name |

DEFAULT_TAX_TYPE value example:
```json
{
  "country": "GB",
  "group": "STANDARD",
  "tariff": "VAT"
}
```
Additionally, setting named as tariff name have to exist. This setting shows amount of tax.

| Property   | Value                          |
|------------|--------------------------------|
| Name       | tariff name (for example: VAT) |
| Context    | RETAILER                       |
| Context Id | <retailer_id>                  |
| Value Type | STRING                         |
| Value      | Tax amount (for example, 0.2)  |


`EDIT_LOCATION_COUNTRIES` - list of countries to use it in country selector

| Property   | Value                   |
|------------|-------------------------|
| Name       | EDIT_LOCATION_COUNTRIES |
| Context    | ACCOUNT                 |
| Context Id | 0                       |
| Value Type | STRING                  |
| Value      | List of countries       |

EDIT_LOCATION_COUNTRIES value example: 
```
[
    "Australia",
    "Canada",
    "France",
    "Germany",
    "United Kingdom",
    "United States"
]
```


`RETURN_IMAGE_OPTIONS` - configuration of saved return items photos

| Property   | Value                                                         |
|------------|---------------------------------------------------------------|
| Name       | RETURN_IMAGE_OPTIONS                                          |
| Context    | ACCOUNT                                                       |
| Context Id | 0                                                             |
| Value Type | JSON                                                          |
| Value      | Saved images configuration (image type and image compression) |

RETURN_IMAGE_OPTIONS value example:
```
{
    "imageType": "jpg",
    "imageCompression": "0.3"
}
```


`DEFAULT_RETURN_DESTINATION_LOCATION` - default return destination location

| Property   | Value                                                                         |
|------------|-------------------------------------------------------------------------------|
| Name       | DEFAULT_RETURN_DESTINATION_LOCATION                                           |
| Context    | RETAILER                                                                      |
| Context Id | <retailer_id>                                                                 |
| Value Type | STRING                                                                        |
| Value      | Reference of default destination location (for example: STORE_4_RETAILER_REF) |

[List of constants for related settings](src/constants/SettingNames.ts)

## Additional notes 
Environments can have different name conventions (different catalogues prefix). 
So, code have to be modified according to name convention.

Known places:
Different naming of Product Catalogue (MASTER or DEFAULT)
- [AddProductItemsModal.tsx:208](src/components/AddProductItems/AddProductItemsModal.tsx)
- [ExchangeItems.tsx:67](src/forms/fields/returnItems/ExchangeItems.tsx)


## Documentation
<https://fluentpne.atlassian.net/wiki/spaces/SE/pages/5523669409/Return+Order+RMA>\
<https://fluentpne.atlassian.net/wiki/spaces/SE/pages/6243909703/Return+and+Exchange+Enchancements>\
