import { FC } from 'react';
import { Close } from '@material-ui/icons';
import { IconButton } from '@material-ui/core';
import { useTemplateRender } from '../../hooks/useTemplateRender';

interface RemoveButtonProps {
  id: string;
  onClick: (value: string) => void;
  data?: any;
  className?: string;
}

const RemoveButton: FC<RemoveButtonProps> = ({
  className,
  onClick,
  id,
  data,
}) => {
  const templateRender = useTemplateRender();
  return (
    <IconButton
      className={className || ''}
      size="small"
      onClick={() => {
        onClick(templateRender(id, data));
      }}
    >
      <Close />
    </IconButton>
  );
};

export default RemoveButton;
