import { DynamicAttribute } from 'mystique/components/DynamicValue';

export interface OrderItem {
  ref: string;
  name: string;
  quantity: number;
  available: number;
  prices: {
    taxType?: string;
    currency: string;
    value: number;
  }[];
  price: number;
  taxPrice: number;
  taxType?: string;
  imageUrl?: string;
  originalPrice?: number;
  attributes?: DynamicAttribute[];
  promotionPrice?: number;
  promotionTaxPrice?: number;
}

export interface VirtualCatalogue {
  ref: string;
  type?: 'aggregate' | 'base';
}

