import { useSettings } from 'mystique/hooks/useSettings';
import { defaultTaxTypeSettingName } from '../constants/SettingNames';

export const useDefaultTariffValue = () => {
  const defaultTaxTypeSetting = useSettings({
    query: defaultTaxTypeSettingName,
  });

  const defaultTaxType =
    defaultTaxTypeSetting.query.status === 'ok' &&
    defaultTaxTypeSetting.query.result?.value;

  const tariffValueSetting = useSettings({
    query: defaultTaxType?.tariff || '',
  });

  return (
    tariffValueSetting.query.status === 'ok' &&
    tariffValueSetting.query.result?.value
  );
};