import { FieldRegistry } from 'mystique/registry/FieldRegistry';
import { ReturnItemsExtended } from './forms/fields/returnItems/ReturnItemsExtended';
import PickupLocationSelector from './forms/fields/returnItems/PickupLocationSelector';
import DestinationLocationSelector from './forms/fields/returnItems/DestinationLocationSelector';
import { ExchangeItems } from './forms/fields/returnItems/ExchangeItems';
import EmptyField from './forms/fields/EmptyField';
import { ComponentRegistry } from 'mystique/registry/ComponentRegistry';
import ShowAttributesButton from './components/buttons/ShowAttributesButton';
import RemoveButton from './components/buttons/RemoveButton';
import PhotoCapture from './components/PhotoCapture/PhotoCapture';
import { QuantitySelectorComponent } from './components/QuantitySelector/QuantitySelectorComponent';
import { QuantityList } from './components/QuantitySelector/QuantityList';


ComponentRegistry.register(
  ['fc.se.button.show.attributes'],
  ShowAttributesButton,
  {
    category: 'layout',
  },
);
ComponentRegistry.register(
  ['fc.se.quantity.selector'],
  QuantitySelectorComponent,
  {
    category: 'content',
  },
);
ComponentRegistry.register(['fc.se.remove.button'], RemoveButton, {
  category: 'content',
});
ComponentRegistry.register(['fc.se.photo.capture'], PhotoCapture, {
  category: 'content',
});
ComponentRegistry.register(['fc.se.quantity.list'], QuantityList, {
  category: 'content',
});


FieldRegistry.register(['returnItemsExtended'], ReturnItemsExtended);
FieldRegistry.register(['destinationLocation'], DestinationLocationSelector);
FieldRegistry.register(['pickupLocation'], PickupLocationSelector);
FieldRegistry.register(['exchangeItems'], ExchangeItems);
FieldRegistry.register(['emptyField'], EmptyField);
