export const eqIgnoreCase = (a?: string, b?: string): boolean =>
  a?.toUpperCase() === b?.toUpperCase();
export const capitalise = (str: string) =>
  str.charAt(0).toUpperCase() + str.slice(1);

export const camelise = (str: string) =>
  str
    .toLowerCase()
    .replace(/([-_][a-z])/g, (group) =>
      group.toUpperCase().replace('-', '').replace('_', ''),
    );
export const concat = (arr: string[], sep: string) => arr.join(sep);
export const checkStringIsEmpty = (
  value: string | undefined,
  errorText: string,
) => {
  return !value
    ? { error: true, helperText: errorText }
    : { error: false, helperText: '' };
};
export const replaceWordsInText = (
  text: string,
  collection: Map<string, string>,
) => {
  collection.forEach((value, key) => {
    text = text.replace(new RegExp(key, 'g'), value);
  });
  return text;
};

export const humanifyV2 = (str: string) => {
  const formattedStr = str.replace(/:/g, ' ').replace(/_/g, ' ');
  const words = formattedStr.split(' ');
  const transformedWords = words.map((word) => {
    if (isUpperCase(word)) {
      const lowercaseWord = word.toLowerCase();
      return lowercaseWord.charAt(0).toUpperCase() + lowercaseWord.slice(1);
    } else {
      return word;
    }
  });
  return transformedWords.join(' ');
};

function isUpperCase(str: string) {
  return str === str.toUpperCase();
}

export const splitWord = (value: string, splitValue: string) => {
  return value.replace(new RegExp(`(${splitValue})`, 'g'), '\u200B$&');
};

export const decodeHtmlEntities = (str: string) => {
  return str.replace(/&amp;|&lt;|&gt;|&quot;|&#039;/g, function (match) {
    switch (match) {
      case '&amp;':
        return '&';
      case '&lt;':
        return '<';
      case '&gt;':
        return '>';
      case '&quot;':
        return '"';
      case '&#039;':
        return "'";
      default:
        return match;
    }
  });
};

export const insertSpaceBeforeCapitalLetters = (inputString: any) => {
  if (!inputString) {
    return '';
  }
  // Use a regular expression to find capital letters not at the beginning of the string
  if (inputString === inputString.toUpperCase()) {
    return capitalise(inputString.toLowerCase());
  }
  const resultString = inputString.replace(/(?<!^)([A-Z])/g, ' $1');
  return resultString;
};

export const replaceUnderscoreWithSpaceAndCapitalize = (str: string) => {
  // Split the string into an array of words based on underscores

  if (!str) {
    return '';
  }

  const strTemp = str.toLowerCase();

  const words = strTemp.split('_');

  // Iterate through the words and capitalize the first letter of each word
  for (let i = 0; i < words.length; i++) {
    words[i] = words[i].charAt(0).toUpperCase() + words[i].slice(1);
  }

  // Join the words back together with spaces
  const result = words.join(' ');

  return result;
};

export const convertRuleNameToObject = (ruleName: string) => {
  const parts = ruleName.split('.');
  const object = {
    accountId: parts[0],
    pluginName: parts[1],
    ruleName: parts[2],
  };
  return object;
};