package com.fluentcommerce.connect.custom.mapper;

import com.fluentcommerce.connect.custom.data.Address;
import com.fluentcommerce.graphql.queries.location.GetLocationQuery;
import org.jetbrains.annotations.NotNull;


public class AttributeMapper {

    private AttributeMapper() {
        //no-op
    }

    public static Address fromGQL(@NotNull final GetLocationQuery.PrimaryAddress primaryAddress) {
        return Address.builder()
                .street(primaryAddress.street())
                .city(primaryAddress.city())
                .state(primaryAddress.state())
                .postcode(primaryAddress.postcode())
                .country(primaryAddress.country())
                .region(primaryAddress.region())
                .latitude(primaryAddress.latitude())
                .longitude(primaryAddress.longitude())
                .timeZone(primaryAddress.timeZone())
                .build();
    }

}
