package com.fluentcommerce.connect.custom.service;

import static com.fluentcommerce.connect.core.config.CacheConfiguration.SDK_CACHE_MANAGER;
import com.fluentcommerce.connect.core.handler.context.FluentContext;
import com.fluentcommerce.graphql.queries.location.GetLocationQuery;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import javax.validation.constraints.NotNull;
import java.util.Optional;

@Service
@Slf4j
public class LocationService {
    private static final String LOCATION_CACHE = "location";

    @Cacheable(cacheManager = SDK_CACHE_MANAGER, cacheNames = LOCATION_CACHE, key = "#ref")
    public Optional<GetLocationQuery.Location> getLocation(@NotNull final FluentContext context, @NotNull final String ref) {
        final GetLocationQuery query = GetLocationQuery.builder().ref(ref).build();
        final GetLocationQuery.Data locationData = context.executeQuery(query, GetLocationQuery.Data.class);
        if (locationData != null) {
            return Optional.ofNullable(locationData.location());
        }
        return Optional.empty();
    }

}
