package com.fluentcommerce.connect;

import com.fluentcommerce.connect.container.CoreServicesContainerSetupService;
import com.fluentcommerce.connect.message.MessageSender;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import io.qameta.allure.Feature;
import lombok.extern.slf4j.Slf4j;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.junit.jupiter.Testcontainers;

import javax.annotation.PostConstruct;
import java.io.IOException;

import static com.fluentcommerce.connect.common.utils.IntegrationTestUtils.APPLICATION_JSON;
import static com.fluentcommerce.connect.common.utils.IntegrationTestUtils.CONTENT_TYPE_HEADER;
import static com.fluentcommerce.connect.common.utils.IntegrationTestUtils.FLUENT_GRAPHQL_URL;
import static com.fluentcommerce.connect.common.utils.IntegrationTestUtils.baseSetup;
import static com.fluentcommerce.connect.common.utils.IntegrationTestUtils.getResourceAsBytes;
import static com.github.tomakehurst.wiremock.client.WireMock.matching;
import static com.github.tomakehurst.wiremock.client.WireMock.ok;
import static com.github.tomakehurst.wiremock.client.WireMock.post;
import static com.github.tomakehurst.wiremock.client.WireMock.urlPathEqualTo;

@Slf4j
@Feature("Connect SDK Integration Tests")
@Testcontainers
public abstract class ConnectSDKBaseIntegrationTest extends BaseIntegrationTest {
    private static final String GET_SETTINGS_REGEX = ".*GetSettings.*";

    private static final String SQS_BATCH = "SQS_BATCH";
    private static final String SQS_EVENTS = "SQS_EVENTS";
    private static final String SQS_NOTIFICATION = "SQS_NOTIFICATION";
    public static final String EVENTS = "events";
    public static final String BATCH = "batch";
    public static final String NOTIFICATION = "notification";


    @Autowired
    protected MessageSender messageSender;

    @Autowired
    private CoreServicesContainerSetupService coreServicesContainerSetupService;

    @BeforeAll
    static void setup() {
        System.setProperty(SQS_BATCH, BATCH);
        System.setProperty(SQS_EVENTS, EVENTS);
        System.setProperty(SQS_NOTIFICATION, NOTIFICATION);
        BaseIntegrationTest.startWiremockServer();
    }

    @AfterAll
    static void tearDown() {
        fluentWireMockServer.stop();
    }

    @BeforeEach
    void testSetup() {
        baseSetup(fluentWireMockServer);
        fluentWireMockServer.stubFor(post(urlPathEqualTo(FLUENT_GRAPHQL_URL))
                .withRequestBody(matching(GET_SETTINGS_REGEX))
                .willReturn(ok()
                        .withHeader(CONTENT_TYPE_HEADER, APPLICATION_JSON)
                        .withResponseBody(Body.fromJsonBytes(getResourceAsBytes(
                                "it/fc/get_settings_response.json")))));
    }

    @AfterEach
    void afterTest() {
        fluentWireMockServer.findAll(RequestPatternBuilder.allRequests()).forEach(request -> log.info(request.getAbsoluteUrl() + " " + request.getBodyAsString()));
        fluentWireMockServer.resetAll();
    }

    @PostConstruct
    private void setupSecretManager() throws IOException, InterruptedException {
        coreServicesContainerSetupService.createSecret(
                "fc/connect/product-availability-enrichment/api/fluent/activeAccounts",
                "{\"accounts\":[{\"name\":\"TEST\", \"retailers\":[1], \"region\": \"sydney\"}]}"
        );
        coreServicesContainerSetupService.createSecret(
                "fc/connect/product-availability-enrichment/TEST/api/fluent-account/1",
                "{\"retailer\":\"1\", \"userName\":\"username\", \"password\":\"password\"}"
        );
        coreServicesContainerSetupService.createSecret(
                "fc/connect/product-availability-enrichment/TEST/api/fluent-account/api-keys",
                "{\"api-keys\": [{\"retailer\": \"1\",\"username\": \"userName\",\"password\": \"password\",\"keys\": [{\"key\":\"1283712983721983\",\"expiry\":\"9999-12-31T20:28:07.47647529Z\"},{\"key\":\"12456\",\"expiry\":\"2022-12-30T20:28:07.47647529Z\"},{\"key\":\"1283712983721984\",\"expiry\":\"1997-12-30T20:28:07.47647529Z\"},{\"key\":\"1283712983721985\",\"expiry\":\"\"}]}]}"
        );
    }
}
